/*
 * Decompiled with CFR 0.152.
 */
package entities.creatures.enemies;

import core.states.GameState;
import entities.Entity;
import entities.creatures.CreatureEntity;
import entities.creatures.EnemyCreatureEntity;
import entities.missiles.sivir.SivirAbilityQEntity;
import entities.missiles.sivir.SivirShotEntity;
import java.util.ArrayList;
import java.util.Random;
import strategies.ai.SivirAi;
import util.Config;
import util.ResourceManager;

public final class SivirEntity
extends EnemyCreatureEntity {
    private long lastMoveSpeedChange = 0L;
    private Random random;

    public SivirEntity(GameState game, int x, int y) {
        super(game, "creatures/sivir", x, y);
        this.entityIcon = ResourceManager.get().getSprite("icons/sivir/creature");
        this.setHitpoints(Config.get(Config.sivirHitpoints));
        this.setMoveSpeed(Config.get(Config.sivirMoveSpeed));
        this.shotCooldown = Config.get(Config.sivirShotCooldown);
        this.abilityQCooldown = Config.get(Config.sivirAbilityQCooldown);
        this.abilityECooldown = Config.get(Config.sivirAbilityECooldown);
        this.abilityRCooldown = Config.get(Config.sivirAbilityRCooldown);
        this.ai = new SivirAi();
        this.ai.setEntity(this);
    }

    @Override
    protected void set() {
        super.set();
        this.random = new Random();
    }

    @Override
    public void reset() {
        super.reset();
        this.dx = this.random.nextBoolean() ? this.moveSpeed : -this.moveSpeed;
    }

    @Override
    public void move(long delta) {
        if (!this.canMove()) {
            return;
        }
        this.lastMoveSpeedChange += delta;
        if (this.lastMoveSpeedChange > 150L) {
            this.lastMoveSpeedChange = 0L;
            this.dx = this.dx > 0.0 ? Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.dx < 0.0 ? -Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.random.nextBoolean() ? Math.abs(this.random.nextDouble() * this.moveSpeed) : -Math.abs(this.random.nextDouble() * this.moveSpeed)));
            this.dy = this.dy > 0.0 ? Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.dy < 0.0 ? -Math.abs(this.random.nextDouble() * this.moveSpeed) : (this.random.nextBoolean() ? Math.abs(this.random.nextDouble() * this.moveSpeed) : -Math.abs(this.random.nextDouble() * this.moveSpeed)));
        }
        super.move(delta);
    }

    @Override
    public void notifyDeath() {
        ArrayList<Entity> entities = this.game.getEntities();
        for (Entity entity : entities) {
            if (!(entity instanceof SivirAbilityQEntity)) continue;
            this.game.removeEntity(entity);
        }
        ResourceManager.get().stopSound("sivir_abilityR");
        ResourceManager.get().playSound("sivir_die");
        super.notifyDeath();
    }

    @Override
    protected void shot() {
        SivirShotEntity shot = new SivirShotEntity(this, this.game, (int)this.x + this.getW() / 2 - 24, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        ResourceManager.get().playSound("sivir_shot");
    }

    @Override
    protected void abilityQ() {
        SivirAbilityQEntity shot = new SivirAbilityQEntity(this, this.game, (int)this.x + this.getW() / 2 - 24, (int)this.y + this.getH() / 2);
        this.game.addEntity(shot);
        ResourceManager.get().playSound("sivir_abilityQ");
    }

    @Override
    protected void abilityW() {
    }

    @Override
    protected void abilityE() {
        this.addEffect("spellshieldSivir", this.game.getTime() + (long)Config.get(Config.sivirAbilityEDuration));
        ResourceManager.get().playSound("sivir_abilityE");
    }

    @Override
    protected void abilityR() {
        this.addMoveSpeedMultiplier(Config.get(Config.sivirAbilityRSelfMoveSpeedMultiplier), this.game.getTime() + (long)Config.get(Config.sivirAbilityRDuration));
        ArrayList<Entity> entities = this.game.getEntities();
        int i = 0;
        while (i < entities.size()) {
            Entity entity = entities.get(i);
            if (entity instanceof EnemyCreatureEntity && entity != this) {
                ((CreatureEntity)entity).addMoveSpeedMultiplier(Config.get(Config.sivirAbilityRAllyMoveSpeedMultiplier), this.game.getTime() + (long)Config.get(Config.sivirAbilityRDuration));
            }
            ++i;
        }
        ResourceManager.get().playSound("sivir_abilityR");
    }

    @Override
    public void draw() {
        super.draw();
        this.drawHealthbar(0, 50);
    }
}

